package ru.yandex.autotests.directapi.model.api5.ads;

import com.yandex.direct.api.v5.ads.AdAddItem;
import com.yandex.direct.api.v5.ads.SmartAdBuilderAdAdd;

import ru.yandex.direct.core.entity.banner.model.old.OldBannerType;

public class AdAddItemMap {

    public static final String TEXT_AD = "textAd";
    public static final String DYNAMIC_TEXT_AD = "dynamicTextAd";
    public static final String MOBILE_APP_AD = "mobileAppAd";
    public static final String TEXT_IMAGE_AD = "textImageAd";
    public static final String TEXT_AD_BUILDER_AD = "textAdBuilderAd";
    public static final String MOBILE_APP_IMAGE_AD = "mobileAppImageAd";
    public static final String MOBILE_APP_AD_BUILDER_AD = "mobileAppAdBuilderAd";
    public static final String CPC_VIDEO_AD_BUILDER_AD = "cpcVideoAdBuilderAd";
    public static final String CPM_BANNER_AD_BUILDER_AD = "cpmBannerAdBuilderAd";

    private final AdAddItem item;

    public AdAddItemMap() {
        item = new AdAddItem();
    }

    public AdAddItem getBean() {
        return item;
    }

    public AdAddItemMap withAdGroupId(long adGroupId) {
        item.withAdGroupId(adGroupId);
        return this;
    }

    public AdAddItemMap withTextAd(TextAdAddMap textAdAddMap) {
        item.withTextAd(textAdAddMap.getBean());
        return this;
    }

    public AdAddItemMap withTextImageAd(TextImageAdAddMap textImageAdAddMap) {
        item.withTextImageAd(textImageAdAddMap.getBean());
        return this;
    }

    public AdAddItemMap withTextAdBuilderAd(TextAdBuilderAddAdMap textAdBuilderAddAdMap) {
        item.withTextAdBuilderAd(textAdBuilderAddAdMap.getBean());
        return this;
    }

    public AdAddItemMap withMobileAppAd(MobileAppAdAddMap mobileAppAdAddMap) {
        item.withMobileAppAd(mobileAppAdAddMap.getBean());
        return this;
    }

    public AdAddItemMap withMobileAppImageAd(MobileAppImageAdAddMap mobileAppImageAdAddMap) {
        item.withMobileAppImageAd(mobileAppImageAdAddMap.getBean());
        return this;
    }

    public AdAddItemMap withDynamicTextAd(DynamicTextAdAddMap dynamicTextAdAddMap) {
        item.withDynamicTextAd(dynamicTextAdAddMap.getBean());
        return this;
    }

    public AdAddItemMap withSmartAdBuilderAd(SmartAdBuilderAdAdd smartAdBuilderAd) {
        item.withSmartAdBuilderAd(smartAdBuilderAd);
        return this;
    }

    public AdAddItemMap withDefaultAd(OldBannerType type) {
        switch (type) {
            case TEXT:
                item.withTextAd(new TextAdAddMap().defaultTextAd().getBean());
                break;
            case MOBILE_CONTENT:
                item.withMobileAppAd(new MobileAppAdAddMap().defaultMobileAppAd().getBean());
                break;
            case DYNAMIC:
                item.withDynamicTextAd(new DynamicTextAdAddMap().defaultDynamicTextAd().getBean());
                break;
        }
        return this;
    }
}
