package ru.yandex.autotests.directapi.model.api5.ads;

import java.util.stream.Stream;

import com.yandex.direct.api.v5.ads.AddRequest;

import static java.util.stream.Collectors.toList;

public class AddRequestMap {
    private final AddRequest request;

    public AddRequestMap() {
        request = new AddRequest();
    }

    public AddRequest getBean() {
        return request;
    }

    public AddRequestMap withAds(AdAddItemMap... items) {
        request.setAds(Stream.of(items)
                .map(AdAddItemMap::getBean)
                .collect(toList()));
        return this;
    }
}
