package ru.yandex.autotests.directapi.model.api5.ads;

import com.yandex.direct.api.v5.ads.DynamicTextAdAdd;

public class DynamicTextAdAddMap {
    public static final String TEXT = "text";
    public static final String DEFAULT_TEXT = "text";
    public static final int MAX_TEXT_LENGTH = 81;
    public static final int MAX_WORD_IN_TEXT_LENGTH = 23;
    public static final int MAX_AD_EXTENSION_IDS_IN_AD = 50;
    public static final int MAX_NUMBER_OF_NARROW_CHARACTERS = 10;

    private final DynamicTextAdAdd item;

    public DynamicTextAdAddMap() {
        this.item = new DynamicTextAdAdd();
    }

    public DynamicTextAdAdd getBean() {
        return item;
    }

    public DynamicTextAdAddMap withText(String text) {
        item.setText(text);
        return this;
    }

    public DynamicTextAdAddMap defaultDynamicTextAd() {
        item.setText(DEFAULT_TEXT);
        return this;
    }
}
