package ru.yandex.autotests.directapi.model.api5.ads;

import java.util.List;

import com.yandex.direct.api.v5.ads.MobileAppAdAdd;
import com.yandex.direct.api.v5.ads.MobileAppAdFeatureItem;
import com.yandex.direct.api.v5.general.MobileAppAdActionEnum;

import static java.util.Collections.singletonList;

public class MobileAppAdAddMap {
    public static final String AD_IMAGE_HASH = "adImageHash";
    public static final String TEXT = "text";
    public static final String TITLE = "title";
    public static final String TRACKING_URL = "trackingUrl";
    public static final String ACTION = "action";
    public static final String FEATURES = "features";
    public static final String AGE_LABEL = "ageLabel";

    public static final String DEFAULT_TEXT = "DefaultText";
    public static final String DEFAULT_TITLE = "DefaultTitle";
    public static final String DEFAULT_TRACKING_URL = "https://app.appsflyer.com?{logid}";
    public static final String DEFAULT_IMPRESSION_URL = "https://impression.appsflyer.com?{logid}";
    public static final MobileAppAdActionEnum DEFAULT_ACTION = MobileAppAdActionEnum.DOWNLOAD;
    public static final List<MobileAppAdFeatureItem> DEFAULT_FEATURES = singletonList(
            new MobileAppAdFeatureItemMap().defaultMobileAppAdFeature().getBean());

    public static final int MAX_TEXT_LENGTH = 75;
    public static final int MAX_TITLE_LENGTH = 33;
    public static final int MAX_WORD_IN_TEXT_LENGTH = 23;
    public static final int MAX_WORD_IN_TITLE_LENGTH = 22;

    private final MobileAppAdAdd item;

    public MobileAppAdAddMap() {
        item = new MobileAppAdAdd();
    }

    public MobileAppAdAdd getBean() {
        return item;
    }

    public MobileAppAdAddMap defaultMobileAppAd() {
        item
                .withText(DEFAULT_TEXT)
                .withTitle(DEFAULT_TITLE)
                .withAction(DEFAULT_ACTION)
                .withFeatures(DEFAULT_FEATURES)
                .withTrackingUrl(DEFAULT_TRACKING_URL)
                .withImpressionUrl(DEFAULT_IMPRESSION_URL);
        return this;
    }
}
