package ru.yandex.autotests.directapi.model.api5.ads;

import com.yandex.direct.api.v5.ads.MobileAppAdFeatureItem;
import com.yandex.direct.api.v5.ads.MobileAppFeatureEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;

public class MobileAppAdFeatureItemMap {
    public static final String FEATURE = "feature";
    public static final String ENABLED = "enabled";
    public static final MobileAppFeatureEnum DEFAULT_FEATURE;
    public static final YesNoEnum DEFAULT_ENABLED;

    static {
        DEFAULT_FEATURE = MobileAppFeatureEnum.ICON;
        DEFAULT_ENABLED = YesNoEnum.YES;
    }

    private final MobileAppAdFeatureItem item;

    public MobileAppAdFeatureItemMap() {
        item = new MobileAppAdFeatureItem();
    }

    public MobileAppAdFeatureItem getBean() {
        return item;
    }

    public MobileAppAdFeatureItemMap withFeature(MobileAppFeatureEnum feature) {
        item.setFeature(feature);
        return this;
    }

    public MobileAppAdFeatureItemMap withEnabled(YesNoEnum enabled) {
        item.setEnabled(enabled);
        return this;
    }

    public MobileAppAdFeatureItemMap defaultMobileAppAdFeature() {
        item
                .withFeature(DEFAULT_FEATURE)
                .withEnabled(DEFAULT_ENABLED);
        return this;
    }
}
