package ru.yandex.autotests.directapi.model.api5.ads;

import com.yandex.direct.api.v5.ads.MobileAppImageAdAdd;

/**
 * Created by gerdler on 05.07.16.
 */
public class MobileAppImageAdAddMap {
    public static final String TRACKING_URL = "trackingUrl";
    public static final String DEFAULT_TRACKING_URL = "http://appmetrika.yandex.ru";

    private final MobileAppImageAdAdd item;

    public MobileAppImageAdAddMap() {
        this.item = new MobileAppImageAdAdd();
    }

    public MobileAppImageAdAdd getBean() {
        return item;
    }

    public MobileAppImageAdAddMap withTrackingUrl(String trackingUrl) {
        item.withTrackingUrl(trackingUrl);
        return this;
    }

    public MobileAppImageAdAddMap withAdImageHash(String adImageHash) {
        item.withAdImageHash(adImageHash);
        return this;
    }

    public MobileAppImageAdAddMap defaultMobileAppImageAd(String adImageHash) {
        item.withAdImageHash(adImageHash).withTrackingUrl(DEFAULT_TRACKING_URL);
        return this;
    }

}
