package ru.yandex.autotests.directapi.model.api5.ads;

import com.yandex.direct.api.v5.ads.ButtonExtensionAction;
import com.yandex.direct.api.v5.ads.ButtonExtensionAddItem;
import com.yandex.direct.api.v5.ads.TextAdAdd;
import com.yandex.direct.api.v5.ads.VideoExtensionAddItem;
import com.yandex.direct.api.v5.general.YesNoEnum;

public class TextAdAddMap {

    public static final String TEXT = "text";
    public static final String TITLE = "title";
    public static final String TITLE_2 = "title2";
    public static final String HREF = "href";
    public static final String MOBILE = "mobile";
    public static final String DISPLAY_URL_PATH = "displayUrlPath";
    public static final String VIDEO_EXTENSION = "videoExtension";
    public static final String PRICE_EXTENSION = "priceExtension";

    public static final String DEFAULT_TEXT = "text";
    public static final String DEFAULT_TITLE = "title";
    public static final String DEFAULT_TITLE_2 = "title2";
    public static final String DEFAULT_HREF = "http://ya.ru";
    public static final String DEFAULT_DOMAIN = "ya.ru";
    public static final String DEFAULT_DISPLAY_URL_PATH = "defaultpath";

    public static final int MAX_HREF_LENGTH = 1024;
    public static final int MIN_DOMAIN_LENGTH = 1;
    public static final int MAX_DOMAIN_LENGTH = 63;
    public static final int MIN_DISPLAY_URL_PATH = 1;
    public static final int MAX_DISPLAY_URL_PATH = 20;
    public static final int MIN_TOP_DOMAIN_LENGTH = 2;
    public static final int MAX_TOP_DOMAIN_LENGTH = 15;
    public static final int MAX_TITLE_LENGTH = 35;
    public static final int MAX_TITLE_2_LENGTH = 30;
    public static final int MAX_TEXT_LENGTH = 81;
    public static final int MAX_WORD_IN_TITLE_LENGTH = 22;
    public static final int MAX_WORD_IN_TEXT_LENGTH = 23;

    public static final int MAX_AD_EXTENSION_IDS_IN_AD = 50;

    private final TextAdAdd item;

    public TextAdAddMap() {
        this.item = new TextAdAdd();
    }

    public TextAdAdd getBean() {
        return item;
    }

    public TextAdAddMap defaultTextAd() {
        this.item
                .withText(DEFAULT_TEXT)
                .withTitle(DEFAULT_TITLE)
                .withHref(DEFAULT_HREF)
                .withButtonExtension(new ButtonExtensionAddItem()
                        .withAction(ButtonExtensionAction.APPLY)
                        .withHref("http://ya.ru")
                )
                .withMobile(YesNoEnum.NO);
        return this;
    }

    public TextAdAddMap withText(String text) {
        item.setText(text);
        return this;
    }

    public TextAdAddMap withTitle(String title) {
        item.setTitle(title);
        return this;
    }

    public TextAdAddMap withTitle2(String value) {
        item.setTitle2(value);
        return this;
    }

    public TextAdAddMap withHref(String value) {
        item.setHref(value);
        return this;
    }

    public TextAdAddMap withMobile(YesNoEnum value) {
        item.setMobile(value);
        return this;
    }

    public TextAdAddMap withDisplayUrlPath(String value) {
        item.setDisplayUrlPath(value);
        return this;
    }

    public TextAdAddMap withVideoExtension(VideoExtensionAddItem value) {
        item.setVideoExtension(value);
        return this;
    }

    public TextAdAddMap withVCardId(Long value) {
        item.setVCardId(value);
        return this;
    }
}
