package ru.yandex.autotests.directapi.model.api5.ads;

import com.yandex.direct.api.v5.ads.TextAdBuilderAdAdd;

public class TextAdBuilderAddAdMap {
    public static final String HREF = "href";
    public static final String DEFAULT_HREF = "http://ya.ru";

    private final TextAdBuilderAdAdd item;

    public TextAdBuilderAddAdMap() {
        this.item = new TextAdBuilderAdAdd();
    }

    public TextAdBuilderAdAdd getBean() {
        return item;
    }

    public TextAdBuilderAddAdMap withHref(String href) {
        item.withHref(href);
        return this;
    }

    public TextAdBuilderAddAdMap withCreative(AdBuilderAdAddItemMap creative) {
        item.withCreative(creative.getBean());
        return this;
    }

    public TextAdBuilderAddAdMap withCreative(Long creativeId) {
        item.withCreative(new AdBuilderAdAddItemMap().withCreativeId(creativeId).getBean());
        return this;
    }

    public TextAdBuilderAddAdMap defaultTextAdBuilderAd(AdBuilderAdAddItemMap creative) {
        item
                .withCreative(creative.getBean())
                .withHref(DEFAULT_HREF);
        return this;
    }

    public TextAdBuilderAddAdMap defaultTextAdBuilderAd(Long creativeId) {
        item
                .withCreative(new AdBuilderAdAddItemMap().withCreativeId(creativeId).getBean())
                .withHref(DEFAULT_HREF);
        return this;
    }
}
