package ru.yandex.autotests.directapi.model.api5.ads;

import com.yandex.direct.api.v5.ads.TextImageAdAdd;

/**
 * Created by gerdler on 05.07.16.
 */
public class TextImageAdAddMap {
    public static final String HREF = "href";
    public static final String DEFAULT_HREF = "http://ya.ru";
    public static final int MAX_HREF_LENGTH = 1024;

    private final TextImageAdAdd item;

    public TextImageAdAddMap() {
        this.item = new TextImageAdAdd();
    }

    public TextImageAdAdd getBean() {
        return item;
    }

    public TextImageAdAddMap withHref(String href) {
        item.withHref(href);
        return this;
    }

    public TextImageAdAddMap withAdImageHash(String adImageHash) {
        item.withAdImageHash(adImageHash);
        return this;
    }

    public TextImageAdAddMap defaultTextImageAd(String adImageHash) {
        item
                .withAdImageHash(adImageHash)
                .withHref(DEFAULT_HREF);
        return this;
    }

}
