package ru.yandex.autotests.directapi.model.api5.ads;

import java.util.stream.Stream;

import com.yandex.direct.api.v5.ads.UpdateRequest;

import static java.util.stream.Collectors.toList;

public class UpdateRequestMap {

    private final UpdateRequest request;

    public UpdateRequestMap() {
        request = new UpdateRequest();
    }

    public UpdateRequest getBean() {
        return request;
    }


    public UpdateRequestMap withAds(AdUpdateItemMap... items) {
        request.withAds(Stream.of(items)
                .map(AdUpdateItemMap::getBean)
                .collect(toList()));
        return this;
    }

}
