package ru.yandex.autotests.directapi.model.api5.bidmodifiers;

import java.util.stream.Stream;

import com.yandex.direct.api.v5.bidmodifiers.AddRequest;

import static java.util.stream.Collectors.toList;

public class AddRequestMap {
    private final AddRequest request;

    public AddRequestMap() {
        request = new AddRequest();
    }

    public AddRequest getBean() {
        return request;
    }

    public AddRequestMap withBidModifiers(BidModifierAddMap... items) {
        request.withBidModifiers(Stream.of(items)
                .map(BidModifierAddMap::getBean)
                .collect(toList()));
        return this;
    }
}
