package ru.yandex.autotests.directapi.model.api5.bidmodifiers;

import java.util.stream.Stream;

import com.yandex.direct.api.v5.bidmodifiers.SetRequest;

import static java.util.stream.Collectors.toList;

public class SetRequestMap {

    private final SetRequest item;

    public SetRequestMap() {
        item = new SetRequest();
    }

    public SetRequest getBean() {
        return item;
    }

    public SetRequestMap withBidModifiers(BidModifierSetMap... items) {
        item.withBidModifiers(Stream.of(items)
                .map(BidModifierSetMap::getBean)
                .collect(toList()));
        return this;
    }
}
