package ru.yandex.autotests.directapi.model.api5.campaigns;

import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.yandex.direct.api.v5.campaigns.AddRequest;

public class AddRequestMap {
    private final AddRequest request;

    public AddRequestMap() {
        request = new AddRequest();
    }

    public AddRequest getBean() {
        return request;
    }

    public AddRequestMap withCampaigns(CampaignAddItemMap... items) {
        request.setCampaigns(Stream.of(items)
                .map(CampaignAddItemMap::getBean)
                .collect(Collectors.toList()));
        return this;
    }
}
