package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.CampaignAddItem;
import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignAddItem;
import com.yandex.direct.api.v5.campaigns.DailyBudget;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignAddItem;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignAddItem;
import com.yandex.direct.api.v5.campaigns.SmartCampaignAddItem;
import com.yandex.direct.api.v5.campaigns.TextCampaignAddItem;
import com.yandex.direct.api.v5.campaigns.TimeTargetingAdd;
import com.yandex.direct.api.v5.general.ArrayOfString;
import org.joda.time.DateTime;

import ru.yandex.direct.core.entity.campaign.model.CampaignType;

public class CampaignAddItemMap extends CampaignBaseMap<CampaignAddItemMap> {

    public static final String NAME = "name";
    public static final String START_DATE = "startDate";
    public static final String DAILY_BUDGET = "dailyBudget";
    public static final String END_DATE = "endDate";
    public static final String NEGATIVE_KEYWORDS = "negativeKeywords";
    public static final String BLOCKED_IPS = "blockedIps";
    public static final String EXCLUDED_SITES = "excludedSites";
    public static final String TEXT_CAMPAIGN = "textCampaign";
    public static final String MOBILE_APP_CAMPAIGN = "mobileAppCampaign";
    public static final String DYNAMIC_TEXT_CAMPAIGN = "dynamicTextCampaign";
    public static final String CPM_BANNER_CAMPAIGN = "cpmBannerCampaign";
    public static final String SMART_CAMPAIGN = "smartCampaign";

    public static final String DEFAULT_NAME = "Тестовая кампания API5";
    public static final String DEFAULT_CLIENT_INFO = "Иванов Иван Иванович";

    public static final int MAX_NEGATIVE_KEYWORDS_LENGTH = 20000;
    public static final int MAX_WORDS_IN_NEGATIVE_KEYPHRASE = 7;
    public static final int MAX_NAME_LENGTH = 255;
    public static final int MAX_EMAIL_LENGTH = 255;
    public static final int MAX_CLIENT_INFO_LENGTH = 255;
    public static final int MAX_AMOUNT_OF_BLOCKED_IPS = 25;
    public static final int MAX_AMOUNT_OF_EXCLUDED_SITES = 1000;
    public static final String DATE_PATTERN = "yyyy-MM-dd";
    private final CampaignAddItem item;

    public CampaignAddItemMap() {
        this(new CampaignAddItem());
    }

    public CampaignAddItemMap(CampaignAddItem campaignAddItem) {
        item = campaignAddItem;
    }

    private static String campaignNameInfo() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        String reflectionPackage = "sun.reflect";
        int i = 0;
        while (i < stackTrace.length && !stackTrace[i].getClassName().startsWith(reflectionPackage)) {
            i++;
        }
        String info = DateTime.now().toString("HH:mm");
        if (i < stackTrace.length) {
            i--;
            while (i >= 0 && stackTrace[i].getMethodName().matches("<.*>")) {
                i--;
            }
            if (i >= 0) {
                String[] classFullName = stackTrace[i].getClassName().split("\\.");
                String className = classFullName[classFullName.length - 1];
                String methodName = stackTrace[i].getMethodName();
                info += " " + className + "." + methodName;
            }
        }
        return info;
    }

    @Override
    protected CampaignAddItemMap self() {
        return this;
    }

    @Override
    public CampaignAddItem getBean() {
        return item;
    }

    public CampaignAddItemMap withName(String name) {
        item.withName(name);
        return this;
    }

    public CampaignAddItemMap withStartDate(String startDate) {
        item.withStartDate(startDate);
        return this;
    }

    public CampaignAddItemMap withDailyBudget(DailyBudget dailyBudget) {
        item.withDailyBudget(dailyBudget);
        return this;
    }

    public CampaignAddItemMap withEndDate(String endDate) {
        item.withEndDate(endDate);
        return this;
    }

    public CampaignAddItemMap withNegativeKeywords(String... items) {
        item.withNegativeKeywords(new ArrayOfString().withItems(items));
        return this;
    }

    public CampaignAddItemMap withBlockedIps(String... items) {
        item.withBlockedIps(new ArrayOfString().withItems(items));
        return this;
    }

    public CampaignAddItemMap withExcludedSites(String... items) {
        item.withExcludedSites(new ArrayOfString().withItems(items));
        return this;
    }

    public CampaignAddItemMap withTextCampaign(TextCampaignAddItemMap textCampaignAddItemMap) {
        TextCampaignAddItem textCampaignAddItem =
                ((textCampaignAddItemMap == null) ? null : textCampaignAddItemMap.getBean());
        item.withTextCampaign(textCampaignAddItem);
        return this;
    }

    public CampaignAddItemMap withMobileAppCampaign(MobileAppCampaignAddItemMap mobileAppCampaignAddItemMap) {
        MobileAppCampaignAddItem mobileAppCampaignAddItem =
                ((mobileAppCampaignAddItemMap == null) ? null : mobileAppCampaignAddItemMap.getBean());
        item.withMobileAppCampaign(mobileAppCampaignAddItem);
        return this;
    }

    public CampaignAddItemMap withDynamicTextCampaign(DynamicTextCampaignAddItemMap dynamicTextCampaignAddItemMap) {
        DynamicTextCampaignAddItem dynamicTextCampaignAddItem =
                ((dynamicTextCampaignAddItemMap == null) ? null : dynamicTextCampaignAddItemMap.getBean());
        item.withDynamicTextCampaign(dynamicTextCampaignAddItem);
        return this;
    }

    public CampaignAddItemMap withSmartCampaign(SmartCampaignAddItemMap smartCampaignAddItemMap) {
        SmartCampaignAddItem smartCampaignAddItemAddItem =
                (smartCampaignAddItemMap == null) ? null : smartCampaignAddItemMap.getBean();
        item.withSmartCampaign(smartCampaignAddItemAddItem);
        return this;
    }

    public CampaignAddItemMap withCpmBannerCampaign(CpmBannerCampaignAddItemMap cpmBannerCampaignAddItemMap) {
        CpmBannerCampaignAddItem cpmBannerCampaignAddItem =
                (cpmBannerCampaignAddItemMap == null) ? null : cpmBannerCampaignAddItemMap.getBean();
        item.withCpmBannerCampaign(cpmBannerCampaignAddItem);
        return this;
    }

    public CampaignAddItemMap defaultCampaignAddItem() {
        return this
                .withName(DEFAULT_NAME + campaignNameInfo())
                .withStartDate(DateTime.now().toString(DATE_PATTERN));
    }

    public CampaignAddItemMap withTimeTargeting(TimeTargetingAddMap timeTargetingAddMap) {
        TimeTargetingAdd timeTargeting =
                (TimeTargetingAdd) ((timeTargetingAddMap == null) ? null : timeTargetingAddMap.getBean());
        item.withTimeTargeting(timeTargeting);
        return this;
    }

    public CampaignAddItemMap withDefaultTextCampaign() {
        return this.withTextCampaign(new TextCampaignAddItemMap().defaultTextCampaign());
    }

    public CampaignAddItemMap withDefaultDynamicTextCampaign() {
        return this.withDynamicTextCampaign(new DynamicTextCampaignAddItemMap().defaultDynamicTextCampaign());
    }

    public CampaignAddItemMap withDefaultMobileAppCampaign() {
        return this.withMobileAppCampaign(new MobileAppCampaignAddItemMap().defaultMobileAppCampaign());
    }

    public CampaignAddItemMap withDefaultCpmBannerCampaign() {
        return this.withCpmBannerCampaign(new CpmBannerCampaignAddItemMap().defaultCpmBannerCampaign());
    }

    public CampaignAddItemMap withDefaultSmartCampaign(Integer counter) {
        return this.withSmartCampaign(
                new SmartCampaignAddItemMap().defaultSmartCampaign().withCounterId(counter.longValue()));
    }

    public CampaignAddItemMap withDefaultCampaign(CampaignType type) {
        switch (type) {
            case TEXT:
                item.withTextCampaign(new TextCampaignAddItemMap().defaultTextCampaign().getBean());
                break;
            case MOBILE_CONTENT:
                item.withMobileAppCampaign(new MobileAppCampaignAddItemMap().defaultMobileAppCampaign().getBean());
                break;
            case DYNAMIC:
                item.withDynamicTextCampaign(
                        new DynamicTextCampaignAddItemMap().defaultDynamicTextCampaign().getBean());
                break;
            case CPM_BANNER:
                item.withCpmBannerCampaign(
                        new CpmBannerCampaignAddItemMap().defaultCpmBannerCampaign().getBean());
                break;
        }
        return this;
    }
}
