package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.CampaignBase;

import ru.yandex.common.util.RandomUtils;

import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public abstract class CampaignBaseMap<T extends CampaignBaseMap<T>> {

    public static final String CLIENT_INFO = "clientInfo";
    public static final String TIME_TARGETING = "timeTargeting";
    public static final String TIME_ZONE = "timeZone";
    public static final String NOTIFICATION = "notification";

    public static String generateRandomNotPrivateIp() {
        return String.valueOf(RandomUtils.nextIntInRange(40, 126)) + '.' +
                RandomUtils.nextIntInRange(1, 255) + '.' +
                RandomUtils.nextIntInRange(1, 255) + '.' +
                RandomUtils.nextIntInRange(1, 255);
    }

    protected abstract T self();

    public abstract CampaignBase getBean();

    public T withClientInfo(String clientInfo) {
        getBean().withClientInfo(clientInfo);
        return self();
    }

    public T withTimeZone(String timeZone) {
        getBean().withTimeZone(timeZone);
        return self();
    }

    public T withNotification(NotificationMap notificationMap) {
        getBean().withNotification(ifNotNull(notificationMap, NotificationMap::getBean));
        return self();
    }

}
