package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignAddItem;
import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignSetting;
import com.yandex.direct.api.v5.campaigns.FrequencyCapSetting;
import com.yandex.direct.api.v5.general.ArrayOfInteger;
import com.yandex.direct.api.v5.general.VideoTargetEnum;

import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public class CpmBannerCampaignAddItemMap {
    public static final int MAX_AMOUNT_OF_COUNTER_IDS = 100;
    private final CpmBannerCampaignAddItem item;

    public CpmBannerCampaignAddItemMap() {
        this(new CpmBannerCampaignAddItem());
    }

    public CpmBannerCampaignAddItemMap(CpmBannerCampaignAddItem cpmBannerCampaignAddItem) {
        item = cpmBannerCampaignAddItem;
    }

    public CpmBannerCampaignAddItem getBean() {
        return item;
    }

    public CpmBannerCampaignAddItemMap withBiddingStrategy(
            CpmBannerCampaignStrategyAddMap cpmBannerCampaignStrategyAddMap) {
        item.withBiddingStrategy(
                ifNotNull(cpmBannerCampaignStrategyAddMap, CpmBannerCampaignStrategyAddMap::getBean));
        return this;
    }

    public CpmBannerCampaignAddItemMap withSettings(CpmBannerCampaignSetting... settings) {
        item.withSettings(settings);
        return this;
    }

    public CpmBannerCampaignAddItemMap withFrequencyCap(FrequencyCapSetting frequencyCap) {
        item.withFrequencyCap(frequencyCap);
        return this;
    }

    public CpmBannerCampaignAddItemMap defaultCpmBannerCampaign() {
        return this.withBiddingStrategy(new CpmBannerCampaignStrategyAddMap().defaultCpmBannerCampaignStrategy());
    }

    public CpmBannerCampaignAddItemMap withCounterIds(ArrayOfInteger arrayOfInteger) {
        item.withCounterIds(arrayOfInteger);
        return this;
    }

    public CpmBannerCampaignAddItemMap withCounterIds(Integer... items) {
        ArrayOfInteger arrayOfInteger = (items == null) ? null : new ArrayOfInteger().withItems(items);
        return this.withCounterIds(arrayOfInteger);
    }

    public CpmBannerCampaignAddItemMap withVideoTarget(VideoTargetEnum videoTarget) {
        item.withVideoTarget(videoTarget);
        return this;
    }
}
