package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignNetworkStrategyAdd;
import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignNetworkStrategyTypeEnum;

import ru.yandex.direct.currency.Currency;

import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public class CpmBannerCampaignNetworkStrategyAddMap {
    private final CpmBannerCampaignNetworkStrategyAdd item;

    public CpmBannerCampaignNetworkStrategyAddMap() {
        this(new CpmBannerCampaignNetworkStrategyAdd());
    }

    public CpmBannerCampaignNetworkStrategyAddMap(
            CpmBannerCampaignNetworkStrategyAdd cpmBannerCampaignNetworkStrategyAdd) {
        item = cpmBannerCampaignNetworkStrategyAdd;
    }

    public CpmBannerCampaignNetworkStrategyAdd getBean() {
        return item;
    }

    public CpmBannerCampaignNetworkStrategyAddMap withBiddingStrategyType(
            CpmBannerCampaignNetworkStrategyTypeEnum biddingStrategyType) {
        item.withBiddingStrategyType(biddingStrategyType);
        return this;
    }

    public CpmBannerCampaignNetworkStrategyAddMap withWbMaximumImpressions(StrategyWbMaximumImpressionsAddMap paramsMap) {
        item.withWbMaximumImpressions(ifNotNull(paramsMap, StrategyWbMaximumImpressionsAddMap::getBean));
        return this;
    }

    public CpmBannerCampaignNetworkStrategyAddMap withCpMaximumImpressions(StrategyCpMaximumImpressionsAddMap paramsMap) {
        item.withCpMaximumImpressions(ifNotNull(paramsMap, StrategyCpMaximumImpressionsAddMap::getBean));
        return this;
    }

    public CpmBannerCampaignNetworkStrategyAddMap withWbAverageCpv(StrategyWbAverageCpvAddMap paramsMap) {
        item.withWbAverageCpv(ifNotNull(paramsMap, StrategyWbAverageCpvAddMap::getBean));
        return this;
    }

    public CpmBannerCampaignNetworkStrategyAddMap withCpAverageCpv(StrategyCpAverageCpvAddMap paramsMap) {
        item.withCpAverageCpv(ifNotNull(paramsMap, StrategyCpAverageCpvAddMap::getBean));
        return this;
    }

    public CpmBannerCampaignNetworkStrategyAddMap withWbDecreasedPriceForRepeatedImpressions(StrategyWbDecreasedPriceForRepeatedImpressionsAddMap paramsMap) {
        item.withWbDecreasedPriceForRepeatedImpressions(ifNotNull(paramsMap,
                StrategyWbDecreasedPriceForRepeatedImpressionsAddMap::getBean));
        return this;
    }

    public CpmBannerCampaignNetworkStrategyAddMap withCpDecreasedPriceForRepeatedImpressions(StrategyCpDecreasedPriceForRepeatedImpressionsAddMap paramsMap) {
        item.withCpDecreasedPriceForRepeatedImpressions(ifNotNull(paramsMap,
                StrategyCpDecreasedPriceForRepeatedImpressionsAddMap::getBean));
        return this;
    }

    public CpmBannerCampaignNetworkStrategyAddMap defaultStrategyWbMaximumImpressions(Currency currency) {
        return this.withBiddingStrategyType(CpmBannerCampaignNetworkStrategyTypeEnum.WB_MAXIMUM_IMPRESSIONS).withWbMaximumImpressions(
                new StrategyWbMaximumImpressionsAddMap().defaultStrategyWbMaximumImpressions(currency)
        );
    }
}
