package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignStrategyAdd;

import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public class CpmBannerCampaignStrategyAddMap {
    private final CpmBannerCampaignStrategyAdd item;

    public CpmBannerCampaignStrategyAddMap() {
        this(new CpmBannerCampaignStrategyAdd());
    }

    public CpmBannerCampaignStrategyAddMap(CpmBannerCampaignStrategyAdd cpmBannerCampaignStrategyAdd) {
        item = cpmBannerCampaignStrategyAdd;
    }

    public CpmBannerCampaignStrategyAdd getBean() {
        return item;
    }

    public CpmBannerCampaignStrategyAddMap withSearch(
            CpmBannerCampaignSearchStrategyAddMap search) {
        item.withSearch(ifNotNull(search, CpmBannerCampaignSearchStrategyAddMap::getBean));
        return this;
    }

    public CpmBannerCampaignStrategyAddMap withNetwork(
            CpmBannerCampaignNetworkStrategyAddMap network) {
        item.withNetwork(ifNotNull(network, CpmBannerCampaignNetworkStrategyAddMap::getBean));
        return this;
    }

    public CpmBannerCampaignStrategyAddMap defaultCpmBannerCampaignStrategy() {
        return this
                .withSearch(new CpmBannerCampaignSearchStrategyAddMap()
                        .withBiddingStrategyType(CpmBannerCampaignSearchStrategyTypeEnum.SERVING_OFF))
                .withNetwork(new CpmBannerCampaignNetworkStrategyAddMap()
                        .withBiddingStrategyType(CpmBannerCampaignNetworkStrategyTypeEnum.MANUAL_CPM));
    }
}
