package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignAddItem;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSetting;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignStrategyAdd;
import com.yandex.direct.api.v5.campaigns.PlacementType;
import com.yandex.direct.api.v5.general.ArrayOfInteger;
import com.yandex.direct.api.v5.general.AttributionModelEnum;

import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public class DynamicTextCampaignAddItemMap {
    public static final int MAX_AMOUNT_OF_COUNTER_IDS = 100;
    private final DynamicTextCampaignAddItem item;

    public DynamicTextCampaignAddItemMap() {
        this(new DynamicTextCampaignAddItem());
    }

    public DynamicTextCampaignAddItemMap(DynamicTextCampaignAddItem dynamicTextCampaignAddItem) {
        item = dynamicTextCampaignAddItem;
    }

    public DynamicTextCampaignAddItem getBean() {
        return item;
    }

    public DynamicTextCampaignAddItemMap withBiddingStrategy(
            DynamicTextCampaignStrategyAddMap dynamicTextCampaignStrategyAddMap) {
        DynamicTextCampaignStrategyAdd dynamicTextCampaignStrategyAdd =
                ifNotNull(dynamicTextCampaignStrategyAddMap, DynamicTextCampaignStrategyAddMap::getBean);
        item.withBiddingStrategy(dynamicTextCampaignStrategyAdd);
        return this;
    }

    public DynamicTextCampaignAddItemMap withSettings(DynamicTextCampaignSetting... settings) {
        item.withSettings(settings);
        return this;
    }

    public DynamicTextCampaignAddItemMap defaultDynamicTextCampaign() {
        return this.withBiddingStrategy(new DynamicTextCampaignStrategyAddMap().defaultDynamicTextCampaignStrategy());
    }

    public DynamicTextCampaignAddItemMap withCounterIds(ArrayOfInteger counterIds) {
        item.withCounterIds(counterIds);
        return this;
    }

    public DynamicTextCampaignAddItemMap withCounterIds(Integer... items) {
        return this.withCounterIds(new ArrayOfInteger().withItems(items));
    }

    public DynamicTextCampaignAddItemMap withPriorityGoals(PriorityGoalsArrayMap priorityGoalsArrayMap) {
        item.withPriorityGoals(ifNotNull(priorityGoalsArrayMap, PriorityGoalsArrayMap::getBean));
        return this;
    }

    public DynamicTextCampaignAddItemMap withPriorityGoals(PriorityGoalsItemMap... priorityGoals) {
        var array = new PriorityGoalsArrayMap().withItems(priorityGoals);
        return this.withPriorityGoals(array);
    }

    public DynamicTextCampaignAddItemMap withAttributionModel(AttributionModelEnum attributionModel) {
        item.withAttributionModel(attributionModel);
        return this;
    }

    public DynamicTextCampaignAddItemMap withPlacementTypes(PlacementType... placementTypes) {
        item.withPlacementTypes(placementTypes);
        return this;
    }

}
