package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyAdd;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyTypeEnum;

import ru.yandex.direct.currency.Currency;

public class DynamicTextCampaignSearchStrategyAddMap extends DynamicTextCampaignStrategyAddBaseMap<DynamicTextCampaignSearchStrategyAddMap> {
    private final DynamicTextCampaignSearchStrategyAdd item;

    public DynamicTextCampaignSearchStrategyAddMap() {
        this(new DynamicTextCampaignSearchStrategyAdd());
    }

    public DynamicTextCampaignSearchStrategyAddMap(DynamicTextCampaignSearchStrategyAdd mobileAppCampaignSearchStrategy) {
        item = mobileAppCampaignSearchStrategy;
    }

    @Override
    protected DynamicTextCampaignSearchStrategyAdd getBean() {
        return item;
    }

    @Override
    protected DynamicTextCampaignSearchStrategyAddMap self() {
        return this;
    }

    public DynamicTextCampaignSearchStrategyAddMap withBiddingStrategyType(
            DynamicTextCampaignSearchStrategyTypeEnum biddingStrategyType) {
        item.withBiddingStrategyType(biddingStrategyType);
        return this;
    }

    public DynamicTextCampaignSearchStrategyAddMap defaultServingOff() {
        return this.withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.SERVING_OFF);
    }

    public DynamicTextCampaignSearchStrategyAddMap defaultHighestPosition() {
        return this.withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.HIGHEST_POSITION);
    }

    public DynamicTextCampaignSearchStrategyAddMap defaultWbMaximumClicks(Currency currency) {
        return this
                .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CLICKS)
                .withWbMaximumClicks(new StrategyMaximumClicksAddMap()
                        .defaultStrategyMaximumClicks(currency));
    }

    public DynamicTextCampaignSearchStrategyAddMap defaultWbMaximumConversionRate(Currency currency, Long goalId) {
        return this
                .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CONVERSION_RATE)
                .withWbMaximumConversionRate(new StrategyMaximumConversionRateAddMap()
                        .defaultMaximumConversionRateParams(currency)
                        .withGoalId(goalId));
    }

    public DynamicTextCampaignSearchStrategyAddMap defaultAverageCpc(Currency currency) {
        return this
                .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_CPC)
                .withAverageCpc(new StrategyAverageCpcAddMap()
                        .defaultStrategyAverageCpc(currency));
    }

    public DynamicTextCampaignSearchStrategyAddMap defaultAverageCpa(Currency currency, Long goalId) {
        return this
                .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_CPA)
                .withAverageCpa(new StrategyAverageCpaAddMap()
                        .defaultStrategyAverageCpa(currency)
                        .withGoalId(goalId));
    }

    public DynamicTextCampaignSearchStrategyAddMap defaultAverageRoi(Long goalId) {
        return this
                .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_ROI)
                .withAverageRoi(new StrategyAverageRoiAddMap()
                        .defaultStrategyAverageRoi()
                        .withGoalId(goalId));
    }
}
