package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategy;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyTypeEnum;

import ru.yandex.direct.currency.Currency;

/**
 * Created by pavryabov on 17.11.15.
 */
public class DynamicTextCampaignSearchStrategyMap extends DynamicTextCampaignStrategyBaseMap<DynamicTextCampaignSearchStrategyMap> {

    public static final String BIDDING_STRATEGY_TYPE = "biddingStrategyType";
    private final DynamicTextCampaignSearchStrategy item;

    public DynamicTextCampaignSearchStrategyMap() {
        this(new DynamicTextCampaignSearchStrategy());
    }

    public DynamicTextCampaignSearchStrategyMap(DynamicTextCampaignSearchStrategy dynamicTextCampaignSearchStrategy) {
        item = dynamicTextCampaignSearchStrategy;
    }

    @Override
    protected DynamicTextCampaignSearchStrategy getBean() {
        return item;
    }

    @Override
    protected DynamicTextCampaignSearchStrategyMap self() {
        return this;
    }

    public DynamicTextCampaignSearchStrategyMap withBiddingStrategyType(
            DynamicTextCampaignSearchStrategyTypeEnum biddingStrategyType) {
        item.withBiddingStrategyType(biddingStrategyType);
        return this;
    }

    public DynamicTextCampaignSearchStrategyMap defaultHighestPosition() {
        return this.withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.HIGHEST_POSITION);
    }

    public DynamicTextCampaignSearchStrategyMap defaultWbMaximumClicks(Currency currency) {
        return this
                .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CLICKS)
                .withWbMaximumClicks(new StrategyMaximumClicksMap()
                        .defaultStrategyMaximumClicks(currency));
    }

    public DynamicTextCampaignSearchStrategyMap defaultWbMaximumConversionRate(Currency currency, Long goalId) {
        return this
                .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CONVERSION_RATE)
                .withWbMaximumConversionRate(new StrategyMaximumConversionRateMap()
                        .defaultMaximumConversionRateParams(currency)
                        .withGoalId(goalId));
    }

    public DynamicTextCampaignSearchStrategyMap defaultAverageCpc(Currency currency) {
        return this
                .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_CPC)
                .withAverageCpc(new StrategyAverageCpcMap()
                        .defaultStrategyAverageCpc(currency));
    }

    public DynamicTextCampaignSearchStrategyMap defaultAverageCpa(Currency currency, Long goalId) {
        return this
                .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_CPA)
                .withAverageCpa(new StrategyAverageCpaMap()
                        .defaultStrategyAverageCpa(currency)
                        .withGoalId(goalId));
    }

    public DynamicTextCampaignSearchStrategyMap defaultAverageRoi(Long goalId) {
        return this
                .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.AVERAGE_ROI)
                .withAverageRoi(new StrategyAverageRoiMap()
                        .defaultStrategyAverageRoi()
                        .withGoalId(goalId));
    }
}
