package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignStrategyAdd;

import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public class DynamicTextCampaignStrategyAddMap {
    private final DynamicTextCampaignStrategyAdd item;

    public DynamicTextCampaignStrategyAddMap() {
        this(new DynamicTextCampaignStrategyAdd());
    }

    public DynamicTextCampaignStrategyAddMap(DynamicTextCampaignStrategyAdd dynamicTextCampaignStrategyAdd) {
        item = dynamicTextCampaignStrategyAdd;
    }

    public DynamicTextCampaignStrategyAdd getBean() {
        return item;
    }

    public DynamicTextCampaignStrategyAddMap withSearch(
            DynamicTextCampaignSearchStrategyAddMap search) {
        item.withSearch(ifNotNull(search, DynamicTextCampaignSearchStrategyAddMap::getBean));
        return this;
    }

    public DynamicTextCampaignStrategyAddMap withNetwork(
            DynamicTextCampaignNetworkStrategyAddMap network) {
        item.withNetwork(ifNotNull(network, DynamicTextCampaignNetworkStrategyAddMap::getBean));
        return this;
    }

    public DynamicTextCampaignStrategyAddMap defaultDynamicTextCampaignStrategy() {
        return this
                .withSearch(new DynamicTextCampaignSearchStrategyAddMap()
                        .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.HIGHEST_POSITION))
                .withNetwork(new DynamicTextCampaignNetworkStrategyAddMap()
                        .withBiddingStrategyType(DynamicTextCampaignNetworkStrategyTypeEnum.SERVING_OFF));
    }
}
