package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignStrategyBase;

import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public abstract class DynamicTextCampaignStrategyBaseMap<T extends DynamicTextCampaignStrategyBaseMap<T>> {

    protected abstract DynamicTextCampaignStrategyBase getBean();

    protected abstract T self();

    public T withWbMaximumClicks(StrategyMaximumClicksMap paramsMap) {
        getBean().withWbMaximumClicks(ifNotNull(paramsMap, StrategyMaximumClicksMap::getBean));
        return self();
    }

    public T withWbMaximumConversionRate(StrategyMaximumConversionRateMap paramsMap) {
        getBean().withWbMaximumConversionRate(ifNotNull(paramsMap, StrategyMaximumConversionRateMap::getBean));
        return self();
    }

    public T withAverageCpc(StrategyAverageCpcMap paramsMap) {
        getBean().withAverageCpc(ifNotNull(paramsMap, StrategyAverageCpcMap::getBean));
        return self();
    }

    public T withWeeklyClickPackage(StrategyWeeklyClickPackageMap paramsMap) {
        getBean().withWeeklyClickPackage(ifNotNull(paramsMap, StrategyWeeklyClickPackageMap::getBean));
        return self();
    }

    public T withAverageCpa(StrategyAverageCpaMap paramsMap) {
        getBean().withAverageCpa(ifNotNull(paramsMap, StrategyAverageCpaMap::getBean));
        return self();
    }

    public T withPayForConversion(StrategyPayForConversionMap paramsMap) {
        getBean().withPayForConversion(ifNotNull(paramsMap, StrategyPayForConversionMap::getBean));
        return self();
    }

    public T withPayForConversionCrr(StrategyPayForConversionCrrMap paramsMap) {
        getBean().withPayForConversionCrr(ifNotNull(paramsMap, StrategyPayForConversionCrrMap::getBean));
        return self();
    }

    public T withAverageRoi(StrategyAverageRoiMap paramsMap) {
        getBean().withAverageRoi(ifNotNull(paramsMap, StrategyAverageRoiMap::getBean));
        return self();
    }

    public T withAverageCrr(StrategyAverageCrrMap paramsMap) {
        getBean().withAverageCrr(ifNotNull(paramsMap, StrategyAverageCrrMap::getBean));
        return self();
    }
}
