package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignStrategy;

import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public class DynamicTextCampaignStrategyMap {
    private final DynamicTextCampaignStrategy item;

    public DynamicTextCampaignStrategyMap() {
        this(new DynamicTextCampaignStrategy());
    }

    public DynamicTextCampaignStrategyMap(DynamicTextCampaignStrategy dynamicTextCampaignStrategy) {
        item = dynamicTextCampaignStrategy;
    }

    public DynamicTextCampaignStrategy getBean() {
        return item;
    }

    public DynamicTextCampaignStrategyMap withSearch(
            DynamicTextCampaignSearchStrategyMap search) {
        item.withSearch(ifNotNull(search, DynamicTextCampaignSearchStrategyMap::getBean));
        return this;
    }

    public DynamicTextCampaignStrategyMap withNetwork(
            DynamicTextCampaignNetworkStrategyMap network) {
        item.withNetwork(ifNotNull(network, DynamicTextCampaignNetworkStrategyMap::getBean));
        return this;
    }

    public DynamicTextCampaignStrategyMap defaultDynamicTextCampaignStrategy() {
        return this
                .withSearch(new DynamicTextCampaignSearchStrategyMap()
                        .withBiddingStrategyType(DynamicTextCampaignSearchStrategyTypeEnum.HIGHEST_POSITION))
                .withNetwork(new DynamicTextCampaignNetworkStrategyMap()
                        .withBiddingStrategyType(DynamicTextCampaignNetworkStrategyTypeEnum.SERVING_OFF));
    }
}
