package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.EmailSettings;
import com.yandex.direct.api.v5.general.YesNoEnum;

public class EmailSettingsMap {

    public static final String EMAIL = "email";
    public static final String CHECK_POSITION_INTERVAL = "checkPositionInterval";
    public static final String WARNING_BALANCE = "warningBalance";
    public static final String SEND_ACCOUNT_NEWS = "sendAccountNews";
    public static final String SEND_WARNINGS = "sendWarnings";

    public static final String DEFAULT_EMAIL = "at-tester@yandex-team.ru";
    public static final YesNoEnum DEFAULT_SEND_ACCOUNT_NEWS = YesNoEnum.YES;
    public static final YesNoEnum DEFAULT_SEND_WARNINGS = YesNoEnum.YES;

    public static final int MIN_WARNING_BALANCE = 1;
    public static final int MAX_WARNING_BALANCE = 50;

    private final EmailSettings item;

    public EmailSettingsMap() {
        this(new EmailSettings());
    }

    public EmailSettingsMap(EmailSettings emailSettings) {
        item = emailSettings;
    }

    public EmailSettings getBean() {
        return item;
    }

    public EmailSettingsMap withEmail(String email) {
        item.withEmail(email);
        return this;
    }

    public EmailSettingsMap withCheckPositionInterval(Integer checkPositionInterval) {
        item.withCheckPositionInterval(checkPositionInterval);
        return this;
    }

    public EmailSettingsMap withWarningBalance(Integer warningBalance) {
        item.withWarningBalance(warningBalance);
        return this;
    }

    public EmailSettingsMap withSendAccountNews(YesNoEnum sendAccountNews) {
        item.withSendAccountNews(sendAccountNews);
        return this;
    }

    public EmailSettingsMap withSendWarnings(YesNoEnum sendWarnings) {
        item.withSendWarnings(sendWarnings);
        return this;
    }

    public EmailSettingsMap defaultEmailSettings() {
        return this
                .withEmail(DEFAULT_EMAIL)
                .withSendAccountNews(DEFAULT_SEND_ACCOUNT_NEWS)
                .withSendWarnings(DEFAULT_SEND_WARNINGS);
    }
}
