package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignsSelectionCriteria;
import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.GetRequest;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.SmartCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignFieldEnum;

import ru.yandex.autotests.directapi.model.api5.general.GetRequestGeneralMap;

/**
 * Created by ginger on 22.07.15.
 */
public class GetRequestMap extends GetRequestGeneralMap<GetRequestMap> {

    public static final String SELECTION_CRITERIA = "selectionCriteria";
    public static final String FIELD_NAMES = "fieldNames";
    public static final String TEXT_CAMPAIGN_FIELD_NAMES = "textCampaignFieldNames";
    public static final String MOBILE_APP_CAMPAIGN_FIELD_NAMES = "mobileAppCampaignFieldNames";
    public static final String DYNAMIC_TEXT_CAMPAIGN_FIELD_NAMES = "dynamicTextCampaignFieldNames";
    public static final String CPM_BANNER_CAMPAIGN_FIELD_NAMES = "cpmBannerCampaignFieldNames";
    public static final String SMART_CAMPAIGN_FIELD_NAMES = "smartCampaignFieldNames";
    private final GetRequest item;

    public GetRequestMap() {
        this(new GetRequest());
    }

    public GetRequestMap(GetRequest getRequest) {
        item = getRequest;
    }

    @Override
    protected GetRequestMap self() {
        return this;
    }

    @Override
    public GetRequest getBean() {
        return item;
    }

    public GetRequestMap withSelectionCriteria(CampaignsSelectionCriteria selectionCriteria) {
        item.withSelectionCriteria(selectionCriteria);
        return this;
    }

    public GetRequestMap withFieldNames(CampaignFieldEnum... fieldNames) {
        item.withFieldNames(fieldNames);
        return this;
    }

    public GetRequestMap withAllFieldNames() {
        item.withFieldNames(CampaignFieldEnum.class.getEnumConstants());
        return this;
    }


    public GetRequestMap withTextCampaignFieldNames(TextCampaignFieldEnum... fieldNames) {
        item.withTextCampaignFieldNames(fieldNames);
        return this;
    }

    public GetRequestMap withAllTextCampaignFieldNames() {
        item.withTextCampaignFieldNames(TextCampaignFieldEnum.class.getEnumConstants());
        return this;
    }

    public GetRequestMap withDynamicTextCampaignFieldNames(DynamicTextCampaignFieldEnum... fieldNames) {
        item.withDynamicTextCampaignFieldNames(fieldNames);
        return this;
    }

    public GetRequestMap withAllDynamicTextCampaignFieldNames() {
        item.withDynamicTextCampaignFieldNames(DynamicTextCampaignFieldEnum.class.getEnumConstants());
        return this;
    }

    public GetRequestMap withMobileAppCampaignFieldNames(MobileAppCampaignFieldEnum... fieldNames) {
        item.withMobileAppCampaignFieldNames(fieldNames);
        return this;
    }

    public GetRequestMap withAllMobileAppCampaignFieldNames() {
        item.withMobileAppCampaignFieldNames(MobileAppCampaignFieldEnum.class.getEnumConstants());
        return this;
    }

    public GetRequestMap withCpmBannerCampaignFieldNames(CpmBannerCampaignFieldEnum... fieldNames) {
        item.withCpmBannerCampaignFieldNames(fieldNames);
        return this;
    }

    public GetRequestMap withAllCpmCampaignFieldNames() {
        item.withCpmBannerCampaignFieldNames(CpmBannerCampaignFieldEnum.class.getEnumConstants());
        return this;
    }

    public GetRequestMap withSmartCampaignFieldNames(SmartCampaignFieldEnum... fieldNames) {
        item.withSmartCampaignFieldNames(fieldNames);
        return this;
    }

    public GetRequestMap withAllSmartCampaignFieldNames() {
        item.withSmartCampaignFieldNames(SmartCampaignFieldEnum.class.getEnumConstants());
        return this;
    }
}
