package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.MobileAppCampaignAddItem;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSetting;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignStrategyAdd;

public class MobileAppCampaignAddItemMap {

    public static final String BIDDING_STRATEGY = "biddingStrategy";
    public static final String SETTINGS = "settings";
    private final MobileAppCampaignAddItem item;

    public MobileAppCampaignAddItemMap() {
        this(new MobileAppCampaignAddItem());
    }

    public MobileAppCampaignAddItemMap(MobileAppCampaignAddItem mobileAppCampaignAddItem) {
        item = mobileAppCampaignAddItem;
    }

    public MobileAppCampaignAddItem getBean() {
        return item;
    }

    public MobileAppCampaignAddItemMap withBiddingStrategy(
            MobileAppCampaignStrategyAddMap mobileAppCampaignStrategyAddMap) {
        MobileAppCampaignStrategyAdd mobileAppCampaignStrategy =
                ((mobileAppCampaignStrategyAddMap == null) ? null
                        : mobileAppCampaignStrategyAddMap.getBean());
        item.withBiddingStrategy(mobileAppCampaignStrategy);
        return this;
    }

    public MobileAppCampaignAddItemMap withSettings(MobileAppCampaignSetting... settings) {
        item.withSettings(settings);
        return this;
    }

    public MobileAppCampaignAddItemMap defaultMobileAppCampaign() {
        return this.withBiddingStrategy(new MobileAppCampaignStrategyAddMap().defaultMobileAppCampaignStrategy());
    }
}
