package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.MobileAppCampaignNetworkStrategyAdd;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignNetworkStrategyTypeEnum;

import ru.yandex.direct.currency.Currency;

import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public class MobileAppCampaignNetworkStrategyAddMap extends MobileAppCampaignStrategyAddBaseMap<MobileAppCampaignNetworkStrategyAddMap> {

    public static final String BIDDING_STRATEGY_TYPE = "biddingStrategyType";
    public static final String NETWORK_DEFAULT = "networkDefault";
    private final MobileAppCampaignNetworkStrategyAdd item;

    public MobileAppCampaignNetworkStrategyAddMap() {
        this(new MobileAppCampaignNetworkStrategyAdd());
    }

    public MobileAppCampaignNetworkStrategyAddMap(
            MobileAppCampaignNetworkStrategyAdd mobileAppCampaignNetworkStrategy) {
        item = mobileAppCampaignNetworkStrategy;
    }


    @Override
    protected MobileAppCampaignNetworkStrategyAdd getBean() {
        return item;
    }

    @Override
    protected MobileAppCampaignNetworkStrategyAddMap self() {
        return this;
    }

    public MobileAppCampaignNetworkStrategyAddMap withNetworkDefault(
            StrategyNetworkDefaultAddMap strategyNetworkDefaultAddMap) {
        item.withNetworkDefault(
                ifNotNull(strategyNetworkDefaultAddMap, StrategyNetworkDefaultAddMap::getBean));
        return this;
    }

    public MobileAppCampaignNetworkStrategyAddMap withBiddingStrategyType(
            MobileAppCampaignNetworkStrategyTypeEnum biddingStrategyType) {
        item.withBiddingStrategyType(biddingStrategyType);
        return this;
    }

    public MobileAppCampaignNetworkStrategyAddMap defaultServingOff() {
        return this.withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.SERVING_OFF);
    }

    public MobileAppCampaignNetworkStrategyAddMap defaultMaximumCoverage() {
        return this.withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.MAXIMUM_COVERAGE);
    }

    public MobileAppCampaignNetworkStrategyAddMap defaultNetworkDefault() {
        return this.withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT)
                .withNetworkDefault(new StrategyNetworkDefaultAddMap());
    }

    public MobileAppCampaignNetworkStrategyAddMap defaultNetworkDefaultWithLimitPercent() {
        return this.withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT)
                .withNetworkDefault(new StrategyNetworkDefaultAddMap()
                        .defaultStrategyNetworkDefault());
    }

    public MobileAppCampaignNetworkStrategyAddMap defaultWbMaximumClicks(Currency currency) {
        return this.withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.WB_MAXIMUM_CLICKS)
                .withWbMaximumClicks(new StrategyMaximumClicksAddMap()
                        .defaultStrategyMaximumClicks(currency));
    }

    public MobileAppCampaignNetworkStrategyAddMap defaultWbMaximumAppInstalls(Currency currency) {
        return this.withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.WB_MAXIMUM_APP_INSTALLS)
                .withWbMaximumAppInstalls(new StrategyMaximumAppInstallsAddMap()
                        .defaultStrategyMaximumAppInstalls(currency));
    }

    public MobileAppCampaignNetworkStrategyAddMap defaultAverageCpc(Currency currency) {
        return this.withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.AVERAGE_CPC)
                .withAverageCpc(new StrategyAverageCpcAddMap()
                        .defaultStrategyAverageCpc(currency));
    }

    public MobileAppCampaignNetworkStrategyAddMap defaultAverageCpi(Currency currency) {
        return this.withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.AVERAGE_CPI)
                .withAverageCpi(new StrategyAverageCpiAddMap()
                        .defaultStrategyAverageCpi(currency));
    }

}
