package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSearchStrategyAdd;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSearchStrategyTypeEnum;

import ru.yandex.direct.currency.Currency;

public class MobileAppCampaignSearchStrategyAddMap extends MobileAppCampaignStrategyAddBaseMap<MobileAppCampaignSearchStrategyAddMap> {
    private final MobileAppCampaignSearchStrategyAdd item;

    public MobileAppCampaignSearchStrategyAddMap() {
        this(new MobileAppCampaignSearchStrategyAdd());
    }

    public MobileAppCampaignSearchStrategyAddMap(MobileAppCampaignSearchStrategyAdd mobileAppCampaignSearchStrategy) {
        item = mobileAppCampaignSearchStrategy;
    }

    @Override
    protected MobileAppCampaignSearchStrategyAdd getBean() {
        return item;
    }

    @Override
    protected MobileAppCampaignSearchStrategyAddMap self() {
        return this;
    }

    public MobileAppCampaignSearchStrategyAddMap withBiddingStrategyType(
            MobileAppCampaignSearchStrategyTypeEnum biddingStrategyType) {
        item.withBiddingStrategyType(biddingStrategyType);
        return this;
    }

    public MobileAppCampaignSearchStrategyAddMap defaultServingOff() {
        return this.withBiddingStrategyType(MobileAppCampaignSearchStrategyTypeEnum.SERVING_OFF);
    }

    public MobileAppCampaignSearchStrategyAddMap defaultHighestPosition() {
        return this.withBiddingStrategyType(MobileAppCampaignSearchStrategyTypeEnum.HIGHEST_POSITION);
    }

    public MobileAppCampaignSearchStrategyAddMap defaultWbMaximumClicks(Currency currency) {
        return this
                .withBiddingStrategyType(MobileAppCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CLICKS)
                .withWbMaximumClicks(new StrategyMaximumClicksAddMap()
                        .defaultStrategyMaximumClicks(currency));
    }

    public MobileAppCampaignSearchStrategyAddMap defaultWbMaximumAppInstalls(Currency currency) {
        return this
                .withBiddingStrategyType(MobileAppCampaignSearchStrategyTypeEnum.WB_MAXIMUM_APP_INSTALLS)
                .withWbMaximumAppInstalls(new StrategyMaximumAppInstallsAddMap()
                        .defaultStrategyMaximumAppInstalls(currency));
    }

    public MobileAppCampaignSearchStrategyAddMap defaultAverageCpc(Currency currency) {
        return this
                .withBiddingStrategyType(MobileAppCampaignSearchStrategyTypeEnum.AVERAGE_CPC)
                .withAverageCpc(new StrategyAverageCpcAddMap()
                        .defaultStrategyAverageCpc(currency));
    }

    public MobileAppCampaignSearchStrategyAddMap defaultAverageCpi(Currency currency) {
        return this
                .withBiddingStrategyType(MobileAppCampaignSearchStrategyTypeEnum.AVERAGE_CPI)
                .withAverageCpi(new StrategyAverageCpiAddMap()
                        .defaultStrategyAverageCpi(currency));
    }

}
