package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.MobileAppCampaignStrategyAddBase;
import com.yandex.direct.api.v5.campaigns.StrategyMaximumClicksAdd;

import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public abstract class MobileAppCampaignStrategyAddBaseMap<T extends MobileAppCampaignStrategyAddBaseMap<T>> {
    protected abstract MobileAppCampaignStrategyAddBase getBean();

    protected abstract T self();

    public T withWbMaximumClicks(StrategyMaximumClicksAddMap paramsMap) {
        StrategyMaximumClicksAdd strategyMaximumClicks =
                ((paramsMap == null) ? null : paramsMap.getBean());
        getBean().withWbMaximumClicks(strategyMaximumClicks);
        return self();
    }

    public T withWbMaximumAppInstalls(StrategyMaximumAppInstallsAddMap paramsMap) {
        getBean().withWbMaximumAppInstalls(ifNotNull(paramsMap, StrategyMaximumAppInstallsAddMap::getBean));
        return self();
    }

    public T withAverageCpc(StrategyAverageCpcAddMap paramsMap) {
        getBean().withAverageCpc(ifNotNull(paramsMap, StrategyAverageCpcAddMap::getBean));
        return self();
    }

    public T withAverageCpi(StrategyAverageCpiAddMap paramsMap) {
        getBean().withAverageCpi(ifNotNull(paramsMap, StrategyAverageCpiAddMap::getBean));
        return self();
    }

    public T withPayForInstall(StrategyPayForInstallAddMap paramsMap) {
        getBean().withPayForInstall(ifNotNull(paramsMap, StrategyPayForInstallAddMap::getBean));
        return self();
    }

    public T withWeeklyClickPackage(StrategyWeeklyClickPackageAddMap paramsMap) {
        getBean().withWeeklyClickPackage(ifNotNull(paramsMap, StrategyWeeklyClickPackageAddMap::getBean));
        return self();
    }
}
