package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.MobileAppCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignStrategyAdd;

import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public class MobileAppCampaignStrategyAddMap {
    private final MobileAppCampaignStrategyAdd item;

    public MobileAppCampaignStrategyAddMap() {
        this(new MobileAppCampaignStrategyAdd());
    }

    public MobileAppCampaignStrategyAddMap(MobileAppCampaignStrategyAdd mobileAppCampaignStrategy) {
        item = mobileAppCampaignStrategy;
    }

    public MobileAppCampaignStrategyAdd getBean() {
        return item;
    }

    public MobileAppCampaignStrategyAddMap withSearch(
            MobileAppCampaignSearchStrategyAddMap search) {
        item.withSearch(ifNotNull(search, MobileAppCampaignSearchStrategyAddMap::getBean));
        return this;
    }

    public MobileAppCampaignStrategyAddMap withNetwork(
            MobileAppCampaignNetworkStrategyAddMap network) {
        item.withNetwork(ifNotNull(network, MobileAppCampaignNetworkStrategyAddMap::getBean));
        return this;
    }

    public MobileAppCampaignStrategyAddMap defaultMobileAppCampaignStrategy() {
        return this
                .withSearch(new MobileAppCampaignSearchStrategyAddMap()
                        .withBiddingStrategyType(MobileAppCampaignSearchStrategyTypeEnum.HIGHEST_POSITION))
                .withNetwork(new MobileAppCampaignNetworkStrategyAddMap()
                        .withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.MAXIMUM_COVERAGE));
    }
}
