package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.EmailSettings;
import com.yandex.direct.api.v5.campaigns.Notification;
import com.yandex.direct.api.v5.campaigns.SmsSettings;

import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public class NotificationMap {

    public static final String SMS_SETTINGS = "smsSettings";
    public static final String EMAIL_SETTINGS = "emailSettings";
    private final Notification item;

    public NotificationMap() {
        this(new Notification());
    }

    public NotificationMap(Notification notification) {
        item = notification;
    }

    public Notification getBean() {
        return item;
    }

    public NotificationMap withSmsSettings(SmsSettingsMap smsSettingsMap) {
        SmsSettings smsSettings =
                ifNotNull(smsSettingsMap, SmsSettingsMap::getBean);
        item.withSmsSettings(smsSettings);
        return this;
    }

    public NotificationMap withEmailSettings(EmailSettingsMap emailSettingsMap) {
        EmailSettings emailSettings =
                ifNotNull(emailSettingsMap, EmailSettingsMap::getBean);
        item.withEmailSettings(emailSettings);
        return this;
    }

    public NotificationMap defaultNotification() {
        return this
                .withEmailSettings(new EmailSettingsMap().defaultEmailSettings())
                .withSmsSettings(new SmsSettingsMap().defaultSmsSettings());
    }
}
