package ru.yandex.autotests.directapi.model.api5.campaigns;

import java.util.Arrays;
import java.util.stream.Collectors;

import com.yandex.direct.api.v5.campaigns.PriorityGoalsArray;

public class PriorityGoalsArrayMap {

    public static final String PRIORITY_GOALS_ARRAY_ITEMS = "items";

    public static final int PRIORITY_GOALS_IN_REQUEST_LIMIT = 100;
    private final PriorityGoalsArray item;

    public PriorityGoalsArrayMap() {
        this(new PriorityGoalsArray());
    }

    public PriorityGoalsArrayMap(PriorityGoalsArray priorityGoalsArray) {
        item = priorityGoalsArray;
    }

    public PriorityGoalsArray getBean() {
        return item;
    }

    public PriorityGoalsArrayMap withItems(PriorityGoalsItemMap... items) {
        var convertedItems = Arrays.stream(items)
                .map(PriorityGoalsItemMap::getBean)
                .collect(Collectors.toList());
        item.withItems(convertedItems);
        return this;
    }
}
