package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.PriorityGoalsItem;
import com.yandex.direct.api.v5.general.YesNoEnum;


/**
 * Created by liosha on 21.12.18.
 */
public class PriorityGoalsItemMap {

    public static final String GOAL_ID = "goalId";
    public static final String VALUE = "value";
    public static final String IS_METRIKA_SOURCE_OF_VALUE = "isMetrikaSourceOfValue";

    public static final Long ENGAGED_SESSION_GOAL_ID = 12L;
    private final PriorityGoalsItem item;

    public PriorityGoalsItemMap() {
        this(new PriorityGoalsItem());
    }

    public PriorityGoalsItemMap(PriorityGoalsItem priorityGoal) {
        item = priorityGoal;
    }

    public PriorityGoalsItem getBean() {
        return item;
    }

    public PriorityGoalsItemMap withGoalId(Long goalId) {
        item.withGoalId(goalId);
        return this;
    }

    public PriorityGoalsItemMap withEngagedSessionGoalId() {
        item.withGoalId(ENGAGED_SESSION_GOAL_ID);
        return this;
    }

    public PriorityGoalsItemMap withValue(Long value) {
        item.withValue(value);
        return this;
    }

    public PriorityGoalsItemMap withIsMetrikaSourceOfValue(YesNoEnum value) {
        item.withIsMetrikaSourceOfValue(value);
        return this;
    }
}
