package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.SmartCampaignAddItem;
import com.yandex.direct.api.v5.campaigns.SmartCampaignSetting;

import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public class SmartCampaignAddItemMap {
    private final SmartCampaignAddItem item;

    public SmartCampaignAddItemMap() {
        item = new SmartCampaignAddItem();
    }

    public SmartCampaignAddItemMap withSettings(SmartCampaignSetting... settings) {
        item.withSettings(settings);
        return this;
    }

    public SmartCampaignAddItem getBean() {
        return item;
    }

    public SmartCampaignAddItemMap defaultSmartCampaign() {
        return this.withBiddingStrategy(new SmartCampaignStrategyAddMap().defaultSmartCampaignStrategy());
    }

    public SmartCampaignAddItemMap withBiddingStrategy(
            SmartCampaignStrategyAddMap smartCampaignStrategyAddMap) {
        item.withBiddingStrategy(
                ifNotNull(smartCampaignStrategyAddMap, SmartCampaignStrategyAddMap::getBean));
        return this;
    }

    public SmartCampaignAddItemMap withCounterId(Long counterId) {
        item.withCounterId(counterId);
        return this;
    }

    public SmartCampaignAddItemMap withPriorityGoals(PriorityGoalsArrayMap priorityGoalsArrayMap) {
        item.withPriorityGoals(priorityGoalsArrayMap.getBean());
        return this;
    }
}
