package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.SmartCampaignSearchStrategyAdd;
import com.yandex.direct.api.v5.campaigns.SmartCampaignSearchStrategyTypeEnum;

public class SmartCampaignSearchStrategyAddMap extends SmartCampaignStrategyAddBaseMap<SmartCampaignSearchStrategyAddMap> {
    private final SmartCampaignSearchStrategyAdd item;

    public SmartCampaignSearchStrategyAddMap() {
        this(new SmartCampaignSearchStrategyAdd());
    }

    public SmartCampaignSearchStrategyAddMap(SmartCampaignSearchStrategyAdd smartCampaignSearchStrategy) {
        item = smartCampaignSearchStrategy;
    }

    @Override
    protected SmartCampaignSearchStrategyAdd getBean() {
        return item;
    }

    @Override
    protected SmartCampaignSearchStrategyAddMap self() {
        return this;
    }

    public SmartCampaignSearchStrategyAddMap withBiddingStrategyType(
            SmartCampaignSearchStrategyTypeEnum biddingStrategyType) {
        item.withBiddingStrategyType(biddingStrategyType);
        return this;
    }

    public SmartCampaignSearchStrategyAddMap defaultServingOff() {
        return this.withBiddingStrategyType(SmartCampaignSearchStrategyTypeEnum.SERVING_OFF);
    }
}
