package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.SmartCampaignStrategyAddBase;

import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public abstract class SmartCampaignStrategyAddBaseMap<T extends SmartCampaignStrategyAddBaseMap<T>> {
    protected abstract SmartCampaignStrategyAddBase getBean();

    protected abstract T self();

    public T withWbMaximumConversionRate(StrategyMaximumConversionRateAddMap paramsMap) {
        getBean().withWbMaximumConversionRate(ifNotNull(paramsMap, StrategyMaximumConversionRateAddMap::getBean));
        return self();
    }

    public T withPayForConversionCrr(StrategyPayForConversionCrrAddMap paramsMap) {
        getBean().withPayForConversionCrr(ifNotNull(paramsMap, StrategyPayForConversionCrrAddMap::getBean));
        return self();
    }

    public T withAverageRoi(StrategyAverageRoiAddMap paramsMap) {
        getBean().withAverageRoi(ifNotNull(paramsMap, StrategyAverageRoiAddMap::getBean));
        return self();
    }

    public T withAverageCrr(StrategyAverageCrrAddMap paramsMap) {
        getBean().withAverageCrr(ifNotNull(paramsMap, StrategyAverageCrrAddMap::getBean));
        return self();
    }

    public T withAverageCpcPerCampaign(StrategyAverageCpcPerCampaignAddMap paramsMap) {
        getBean().withAverageCpcPerCampaign(ifNotNull(paramsMap, StrategyAverageCpcPerCampaignAddMap::getBean));
        return self();
    }

    public T withAverageCpcPerFilter(StrategyAverageCpcPerFilterAddMap paramsMap) {
        getBean().withAverageCpcPerFilter(ifNotNull(paramsMap, StrategyAverageCpcPerFilterAddMap::getBean));
        return self();
    }

    public T withAverageCpaPerCampaign(StrategyAverageCpaPerCampaignAddMap paramsMap) {
        getBean().withAverageCpaPerCampaign(ifNotNull(paramsMap, StrategyAverageCpaPerCampaignAddMap::getBean));
        return self();
    }

    public T withAverageCpaPerFilter(StrategyAverageCpaPerFilterAddMap paramsMap) {
        getBean().withAverageCpaPerFilter(ifNotNull(paramsMap, StrategyAverageCpaPerFilterAddMap::getBean));
        return self();
    }

    public T withPayForConversionPerCampaign(StrategyPayForConversionPerCampaignAddMap paramsMap) {
        getBean().withPayForConversionPerCampaign(ifNotNull(paramsMap,
                StrategyPayForConversionPerCampaignAddMap::getBean));
        return self();
    }

    public T withPayForConversionPerFilter(StrategyPayForConversionPerFilterAddMap paramsMap) {
        getBean().withPayForConversionPerFilter(ifNotNull(paramsMap, StrategyPayForConversionPerFilterAddMap::getBean));
        return self();
    }
}
