package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.SmartCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.SmartCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.SmartCampaignStrategyAdd;

import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public class SmartCampaignStrategyAddMap {

    public static final String SEARCH = "search";
    public static final String NETWORK = "network";
    private final SmartCampaignStrategyAdd item;

    public SmartCampaignStrategyAddMap() {
        this(new SmartCampaignStrategyAdd());
    }

    public SmartCampaignStrategyAddMap(SmartCampaignStrategyAdd smartCampaignStrategyAdd) {
        item = smartCampaignStrategyAdd;
    }

    public SmartCampaignStrategyAdd getBean() {
        return item;
    }

    public SmartCampaignStrategyAddMap withSearch(
            SmartCampaignSearchStrategyAddMap search) {
        item.withSearch(ifNotNull(search, SmartCampaignSearchStrategyAddMap::getBean));
        return this;
    }

    public SmartCampaignStrategyAddMap withNetwork(
            SmartCampaignNetworkStrategyAddMap network) {
        item.withNetwork(ifNotNull(network, SmartCampaignNetworkStrategyAddMap::getBean));
        return this;
    }

    public SmartCampaignStrategyAddMap defaultSmartCampaignStrategy() {
        return this
                .withSearch(new SmartCampaignSearchStrategyAddMap()
                        .withBiddingStrategyType(SmartCampaignSearchStrategyTypeEnum.SERVING_OFF))
                .withNetwork(new SmartCampaignNetworkStrategyAddMap()
                        .withBiddingStrategyType(SmartCampaignNetworkStrategyTypeEnum.AVERAGE_CPC_PER_CAMPAIGN)
                        .withAverageCpcPerCampaign(new StrategyAverageCpcPerCampaignAddMap().withAverageCpc(100000000L))
                );

    }
}
