package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.SmsEventsEnum;
import com.yandex.direct.api.v5.campaigns.SmsSettings;

public class SmsSettingsMap {

    public static final String EVENTS = "events";
    public static final String TIME_FROM = "timeFrom";
    public static final String TIME_TO = "timeTo";

    public static final String VALID_TIME_FROM = "12:00";
    public static final String VALID_TIME_TO = "15:00";

    public static final String DEFAULT_TIME_FROM = "00:00";
    public static final String DEFAULT_TIME_TO = "00:00";

    private final SmsSettings item;

    public SmsSettingsMap() {
        this(new SmsSettings());
    }

    public SmsSettingsMap(SmsSettings smsSettings) {
        item = smsSettings;
    }

    public SmsSettings getBean() {
        return item;
    }

    public SmsSettingsMap withEvents(SmsEventsEnum... events) {
        item.withEvents(events);
        return this;
    }

    public SmsSettingsMap withTimeFrom(String timeFrom) {
        item.withTimeFrom(timeFrom);
        return this;
    }

    public SmsSettingsMap withTimeTo(String timeTo) {
        item.withTimeTo(timeTo);
        return this;
    }

    public SmsSettingsMap defaultSmsSettings() {
        return this.withTimeFrom(VALID_TIME_FROM).withTimeTo(VALID_TIME_TO);
    }
}
