package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.StrategyAverageCpaAdd;

import ru.yandex.direct.currency.Currency;

import static ru.yandex.direct.api.v5.common.ConverterUtils.convertToMicros;

public class StrategyAverageCpaAddMap {
    private final StrategyAverageCpaAdd item;

    public StrategyAverageCpaAddMap() {
        this(new StrategyAverageCpaAdd());
    }

    public StrategyAverageCpaAddMap(StrategyAverageCpaAdd strategyAverageCpaAdd) {
        item = strategyAverageCpaAdd;
    }

    public StrategyAverageCpaAdd getBean() {
        return item;
    }

    public StrategyAverageCpaAddMap defaultStrategyAverageCpa(Currency currency) {
        var averagePrice = currency.getMinAutobudgetAvgPrice();
        return this.withAverageCpa(convertToMicros(averagePrice));
    }

    public StrategyAverageCpaAddMap withBidCeiling(Long bidCeiling) {
        item.withBidCeiling(bidCeiling);
        return this;
    }

    public StrategyAverageCpaAddMap withAverageCpa(Long averageCpa) {
        item.withAverageCpa(averageCpa);
        return this;
    }

    public StrategyAverageCpaAddMap withWeeklySpendLimit(Long weeklySpendLimit) {
        item.withWeeklySpendLimit(weeklySpendLimit);
        return this;
    }

    public StrategyAverageCpaAddMap withGoalId(Long goalId) {
        item.withGoalId(goalId);
        return this;
    }
}
