package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.ObjectFactory;
import com.yandex.direct.api.v5.campaigns.StrategyAverageCpa;

import ru.yandex.direct.currency.Currency;

import static ru.yandex.direct.api.v5.common.ConverterUtils.convertToMicros;

public class StrategyAverageCpaMap {
    private static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();
    private final StrategyAverageCpa item;

    public StrategyAverageCpaMap() {
        this(new StrategyAverageCpa());
    }

    public StrategyAverageCpaMap(StrategyAverageCpa strategyAverageCpa) {
        item = strategyAverageCpa;
    }

    public StrategyAverageCpa getBean() {
        return item;
    }

    public StrategyAverageCpaMap defaultStrategyAverageCpa(Currency currency) {
        var averagePrice = currency.getMinAutobudgetAvgPrice();
        return this
                .withAverageCpa(convertToMicros(averagePrice))
                .withBidCeiling(null)
                .withWeeklySpendLimit(null);
    }

    public StrategyAverageCpaMap withBidCeiling(Long bidCeiling) {
        item.withBidCeiling(OBJECT_FACTORY.createStrategyAverageCpaBidCeiling(bidCeiling));
        return this;
    }

    public StrategyAverageCpaMap withAverageCpa(Long averageCpa) {
        item.withAverageCpa(averageCpa);
        return this;
    }

    public StrategyAverageCpaMap withWeeklySpendLimit(Long weeklySpendLimit) {
        item.withWeeklySpendLimit(OBJECT_FACTORY.createStrategyAverageCpaWeeklySpendLimit(weeklySpendLimit));
        return this;
    }

    public StrategyAverageCpaMap withGoalId(Long goalId) {
        item.withGoalId(goalId);
        return this;
    }
}
