package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.StrategyAverageCpaPerCampaignAdd;

import ru.yandex.direct.currency.Currency;

import static ru.yandex.direct.api.v5.common.ConverterUtils.convertToMicros;

public class StrategyAverageCpaPerCampaignAddMap {
    public static final String AVERAGE_CPA = "averageCpa";
    public static final String GOAL_ID = "goalId";
    public static final String BID_CEILING = "bidCeiling";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";
    private final StrategyAverageCpaPerCampaignAdd item;

    public StrategyAverageCpaPerCampaignAddMap() {
        this(new StrategyAverageCpaPerCampaignAdd());
    }

    public StrategyAverageCpaPerCampaignAddMap(StrategyAverageCpaPerCampaignAdd strategyAverageCpaPerCampaignAdd) {
        item = strategyAverageCpaPerCampaignAdd;
    }

    public StrategyAverageCpaPerCampaignAdd getBean() {
        return item;
    }

    public StrategyAverageCpaPerCampaignAddMap defaultStrategyAverageCpaPerCampaignAdd(Currency currency) {
        var averagePrice = currency.getMinAutobudgetAvgPrice();
        return this
                .withAverageCpa(convertToMicros(averagePrice))
                .withBidCeiling(null)
                .withWeeklySpendLimit(null);
    }

    public StrategyAverageCpaPerCampaignAddMap withAverageCpa(Long averageCpa) {
        item.withAverageCpa(averageCpa);
        return this;
    }

    public StrategyAverageCpaPerCampaignAddMap withGoalId(Long goalId) {
        item.withGoalId(goalId);
        return this;
    }

    public StrategyAverageCpaPerCampaignAddMap withBidCeiling(Long bidCeiling) {
        item.withBidCeiling(bidCeiling);
        return this;
    }

    public StrategyAverageCpaPerCampaignAddMap withWeeklySpendLimit(Long weeklySpendLimit) {
        item.withWeeklySpendLimit(weeklySpendLimit);
        return this;
    }
}
