package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.ObjectFactory;
import com.yandex.direct.api.v5.campaigns.StrategyAverageCpaPerCampaign;

import ru.yandex.direct.currency.Currency;

import static ru.yandex.direct.api.v5.common.ConverterUtils.convertToMicros;

public class StrategyAverageCpaPerCampaignMap {
    public static final String AVERAGE_CPA = "averageCpa";
    public static final String GOAL_ID = "goalId";
    public static final String BID_CEILING = "bidCeiling";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";
    private static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();
    private final StrategyAverageCpaPerCampaign item;

    public StrategyAverageCpaPerCampaignMap() {
        this(new StrategyAverageCpaPerCampaign());
    }

    public StrategyAverageCpaPerCampaignMap(StrategyAverageCpaPerCampaign strategyAverageCpaPerCampaign) {
        item = strategyAverageCpaPerCampaign;
    }

    public StrategyAverageCpaPerCampaign getBean() {
        return item;
    }

    public StrategyAverageCpaPerCampaignMap defaultStrategyAverageCpaPerCampaign(Currency currency) {
        var averagePrice = currency.getMinAutobudgetAvgPrice();
        return this
                .withAverageCpa(convertToMicros(averagePrice))
                .withBidCeiling(null)
                .withWeeklySpendLimit(null);
    }

    public StrategyAverageCpaPerCampaignMap withAverageCpa(Long averageCpa) {
        item.withAverageCpa(averageCpa);
        return this;
    }

    public StrategyAverageCpaPerCampaignMap withGoalId(Long goalId) {
        item.withGoalId(goalId);
        return this;
    }

    public StrategyAverageCpaPerCampaignMap withBidCeiling(Long bidCeiling) {
        item.withBidCeiling(OBJECT_FACTORY.createStrategyAverageCpaPerCampaignBidCeiling(bidCeiling));
        return this;
    }

    public StrategyAverageCpaPerCampaignMap withWeeklySpendLimit(Long weeklySpendLimit) {
        item.withWeeklySpendLimit(OBJECT_FACTORY.createStrategyAverageCpaPerCampaignWeeklySpendLimit(weeklySpendLimit));
        return this;
    }
}
