package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.StrategyAverageCpaPerFilterAdd;

import ru.yandex.direct.currency.Currency;

import static ru.yandex.direct.api.v5.common.ConverterUtils.convertToMicros;

public class StrategyAverageCpaPerFilterAddMap {
    private final StrategyAverageCpaPerFilterAdd item;

    public StrategyAverageCpaPerFilterAddMap() {
        this(new StrategyAverageCpaPerFilterAdd());
    }

    public StrategyAverageCpaPerFilterAddMap(StrategyAverageCpaPerFilterAdd strategyAverageCpaPerFilterAdd) {
        item = strategyAverageCpaPerFilterAdd;
    }

    public StrategyAverageCpaPerFilterAdd getBean() {
        return item;
    }

    public StrategyAverageCpaPerFilterAddMap defaultStrategyAverageCpaPerFilterAdd(Currency currency) {
        var averagePrice = currency.getMinAutobudgetAvgPrice();
        return this
                .withFilterAverageCpa(convertToMicros(averagePrice))
                .withBidCeiling(null)
                .withWeeklySpendLimit(null);
    }

    public StrategyAverageCpaPerFilterAddMap withFilterAverageCpa(Long filterAverageCpa) {
        item.withFilterAverageCpa(filterAverageCpa);
        return this;
    }

    public StrategyAverageCpaPerFilterAddMap withGoalId(Long goalId) {
        item.withGoalId(goalId);
        return this;
    }

    public StrategyAverageCpaPerFilterAddMap withBidCeiling(Long bidCeiling) {
        item.withBidCeiling(bidCeiling);
        return this;
    }

    public StrategyAverageCpaPerFilterAddMap withWeeklySpendLimit(Long weeklySpendLimit) {
        item.withWeeklySpendLimit(weeklySpendLimit);
        return this;
    }
}
