package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.ObjectFactory;
import com.yandex.direct.api.v5.campaigns.StrategyAverageCpaPerFilter;

import ru.yandex.direct.currency.Currency;

import static ru.yandex.direct.api.v5.common.ConverterUtils.convertToMicros;

public class StrategyAverageCpaPerFilterMap {
    private static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();
    private final StrategyAverageCpaPerFilter item;

    public StrategyAverageCpaPerFilterMap() {
        this(new StrategyAverageCpaPerFilter());
    }

    public StrategyAverageCpaPerFilterMap(StrategyAverageCpaPerFilter strategyAverageCpaPerFilter) {
        item = strategyAverageCpaPerFilter;
    }

    public StrategyAverageCpaPerFilter getBean() {
        return item;
    }

    public StrategyAverageCpaPerFilterMap defaultStrategyAverageCpaPerFilter(Currency currency) {
        var averagePrice = currency.getMinAutobudgetAvgPrice();
        return this
                .withFilterAverageCpa(convertToMicros(averagePrice))
                .withBidCeiling(null)
                .withWeeklySpendLimit(null);
    }

    public StrategyAverageCpaPerFilterMap withFilterAverageCpa(Long filterAverageCpa) {
        item.withFilterAverageCpa(filterAverageCpa);
        return this;
    }

    public StrategyAverageCpaPerFilterMap withGoalId(Long goalId) {
        item.withGoalId(goalId);
        return this;
    }

    public StrategyAverageCpaPerFilterMap withBidCeiling(Long bidCeiling) {
        item.withBidCeiling(OBJECT_FACTORY.createStrategyAverageCpaPerFilterBidCeiling(bidCeiling));
        return this;
    }

    public StrategyAverageCpaPerFilterMap withWeeklySpendLimit(Long weeklySpendLimit) {
        item.withWeeklySpendLimit(OBJECT_FACTORY.createStrategyAverageCpaPerFilterWeeklySpendLimit(weeklySpendLimit));
        return this;
    }
}
