package ru.yandex.autotests.directapi.model.api5.campaigns;

import java.math.BigDecimal;

import com.yandex.direct.api.v5.campaigns.StrategyAverageCpcAdd;

import ru.yandex.direct.currency.Currency;

import static ru.yandex.direct.api.v5.common.ConverterUtils.convertToMicros;

public class StrategyAverageCpcAddMap {

    public static final String AVERAGE_CPC = "averageCpc";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";
    private final StrategyAverageCpcAdd item;

    public StrategyAverageCpcAddMap() {
        this(new StrategyAverageCpcAdd());
    }

    public StrategyAverageCpcAddMap(StrategyAverageCpcAdd strategyAverageCpcAdd) {
        item = strategyAverageCpcAdd;
    }

    public StrategyAverageCpcAdd getBean() {
        return item;
    }

    public StrategyAverageCpcAddMap defaultStrategyAverageCpc(Currency currency) {
        BigDecimal averagePrice = currency
                .getMinAutobudgetAvgPrice();
        return this.withAverageCpc(convertToMicros(averagePrice));
    }

    public StrategyAverageCpcAddMap withAverageCpc(Long averageCpc) {
        item.withAverageCpc(averageCpc);
        return this;
    }

    public StrategyAverageCpcAddMap withWeeklySpendLimit(Long weeklyLimit) {
        item.withWeeklySpendLimit(weeklyLimit);
        return this;
    }
}
