package ru.yandex.autotests.directapi.model.api5.campaigns;

import java.math.BigDecimal;

import com.yandex.direct.api.v5.campaigns.ObjectFactory;
import com.yandex.direct.api.v5.campaigns.StrategyAverageCpc;

import ru.yandex.direct.currency.Currency;

import static ru.yandex.direct.api.v5.common.ConverterUtils.convertToMicros;

public class StrategyAverageCpcMap {

    public static final String AVERAGE_CPC = "averageCpc";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";
    private static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();
    private final StrategyAverageCpc item;


    public StrategyAverageCpcMap() {
        this(new StrategyAverageCpc());
    }

    public StrategyAverageCpcMap(StrategyAverageCpc strategyAverageCpc) {
        item = strategyAverageCpc;
    }

    public StrategyAverageCpc getBean() {
        return item;
    }

    public StrategyAverageCpcMap defaultStrategyAverageCpc(Currency currency) {
        BigDecimal averagePrice = currency.getMinAutobudgetAvgPrice();
        return this
                .withAverageCpc(convertToMicros(averagePrice))
                .withWeeklySpendLimit(null);
    }

    public StrategyAverageCpcMap withAverageCpc(Long averageCpc) {
        item.withAverageCpc(averageCpc);
        return this;
    }

    public StrategyAverageCpcMap withWeeklySpendLimit(Long weeklyLimit) {
        item.withWeeklySpendLimit(OBJECT_FACTORY.createStrategyAverageCpcWeeklySpendLimit(weeklyLimit));
        return this;
    }
}
