package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.StrategyAverageCpcPerCampaignAdd;

import ru.yandex.direct.currency.Currency;

import static ru.yandex.direct.api.v5.common.ConverterUtils.convertToMicros;

public class StrategyAverageCpcPerCampaignAddMap {

    public static final String AVERAGE_CPC = "averageCpc";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";
    public static final String BID_CEILING = "bidCeiling";
    private final StrategyAverageCpcPerCampaignAdd item;

    public StrategyAverageCpcPerCampaignAddMap() {
        this(new StrategyAverageCpcPerCampaignAdd());
    }

    public StrategyAverageCpcPerCampaignAddMap(StrategyAverageCpcPerCampaignAdd strategyAverageCpcPerCampaignAdd) {
        item = strategyAverageCpcPerCampaignAdd;
    }

    public StrategyAverageCpcPerCampaignAdd getBean() {
        return item;
    }

    public StrategyAverageCpcPerCampaignAddMap defaultStrategyAverageCpcPerCampaignAdd(Currency currency) {
        var averagePrice = currency.getMinAutobudgetAvgPrice();
        return this
                .withAverageCpc(convertToMicros(averagePrice))
                .withBidCeiling(null)
                .withWeeklySpendLimit(null);
    }

    public StrategyAverageCpcPerCampaignAddMap withAverageCpc(Long averageCpc) {
        item.withAverageCpc(averageCpc);
        return this;
    }

    public StrategyAverageCpcPerCampaignAddMap withBidCeiling(Long bidCeiling) {
        item.withBidCeiling(bidCeiling);
        return this;
    }

    public StrategyAverageCpcPerCampaignAddMap withWeeklySpendLimit(Long weeklyLimit) {
        item.withWeeklySpendLimit(weeklyLimit);
        return this;
    }
}
