package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.ObjectFactory;
import com.yandex.direct.api.v5.campaigns.StrategyAverageCpcPerCampaign;

import ru.yandex.direct.currency.Currency;

import static ru.yandex.direct.api.v5.common.ConverterUtils.convertToMicros;

public class StrategyAverageCpcPerCampaignMap {

    public static final String AVERAGE_CPC = "averageCpc";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";
    public static final String BID_CEILING = "bidCeiling";
    private static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();
    private final StrategyAverageCpcPerCampaign item;

    public StrategyAverageCpcPerCampaignMap() {
        this(new StrategyAverageCpcPerCampaign());
    }

    public StrategyAverageCpcPerCampaignMap(StrategyAverageCpcPerCampaign strategyAverageCpcPerCampaign) {
        item = strategyAverageCpcPerCampaign;
    }

    public StrategyAverageCpcPerCampaign getBean() {
        return item;
    }

    public StrategyAverageCpcPerCampaignMap defaultStrategyAverageCpcPerCampaign(Currency currency) {
        var averagePrice = currency.getMinAutobudgetAvgPrice();
        return this
                .withAverageCpc(convertToMicros(averagePrice))
                .withBidCeiling(null)
                .withWeeklySpendLimit(null);
    }

    public StrategyAverageCpcPerCampaignMap withAverageCpc(Long averageCpc) {
        item.withAverageCpc(averageCpc);
        return this;
    }

    public StrategyAverageCpcPerCampaignMap withBidCeiling(Long bidCeiling) {
        item.withBidCeiling(OBJECT_FACTORY.createStrategyAverageCpcPerCampaignBidCeiling(bidCeiling));
        return this;
    }

    public StrategyAverageCpcPerCampaignMap withWeeklySpendLimit(Long weeklyLimit) {
        item.withWeeklySpendLimit(OBJECT_FACTORY.createStrategyAverageCpcPerCampaignWeeklySpendLimit(weeklyLimit));
        return this;
    }
}
