package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.StrategyAverageCpcPerFilterAdd;

import ru.yandex.direct.currency.Currency;

import static ru.yandex.direct.api.v5.common.ConverterUtils.convertToMicros;

public class StrategyAverageCpcPerFilterAddMap {

    public static final String FILTER_AVERAGE_CPC = "filterAverageCpc";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";
    public static final String BID_CEILING = "bidCeiling";
    private final StrategyAverageCpcPerFilterAdd item;

    public StrategyAverageCpcPerFilterAddMap() {
        this(new StrategyAverageCpcPerFilterAdd());
    }

    public StrategyAverageCpcPerFilterAddMap(StrategyAverageCpcPerFilterAdd strategyAverageCpcPerFilterAdd) {
        item = strategyAverageCpcPerFilterAdd;
    }

    public StrategyAverageCpcPerFilterAdd getBean() {
        return item;
    }

    public StrategyAverageCpcPerFilterAddMap defaultStrategyAverageCpcPerFilterAdd(Currency currency) {
        var averagePrice = currency.getMinAutobudgetAvgPrice();
        return this
                .withFilterAverageCpc(convertToMicros(averagePrice))
                .withBidCeiling(null)
                .withWeeklySpendLimit(null);
    }

    public StrategyAverageCpcPerFilterAddMap withFilterAverageCpc(Long averageCpc) {
        item.withFilterAverageCpc(averageCpc);
        return this;
    }

    public StrategyAverageCpcPerFilterAddMap withBidCeiling(Long bidCeiling) {
        item.withBidCeiling(bidCeiling);
        return this;
    }

    public StrategyAverageCpcPerFilterAddMap withWeeklySpendLimit(Long weeklyLimit) {
        item.withWeeklySpendLimit(weeklyLimit);
        return this;
    }
}
